<?php
/**
 * Single Post Template
 * Sportifieds Theme
 */

get_header();
?>

<main id="primary" class="site-main">

<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

    <article id="post-<?php the_ID(); ?>" <?php post_class('sportifieds-single'); ?>>

        <header class="entry-header">
            <h1 class="entry-title"><?php the_title(); ?></h1>

            <div class="entry-meta">
                <span class="author">
                    <?php echo get_avatar( get_the_author_meta('ID'), 32 ); ?>
                    <?php the_author(); ?>
                </span>
                <span class="date">
                    <?php echo get_the_date(); ?>
                </span>
            </div>
        </header>

        <?php if ( has_post_thumbnail() ) : ?>
            <div class="entry-thumbnail">
                <?php the_post_thumbnail('large'); ?>
            </div>
        <?php endif; ?>

        <div class="entry-content">
            <?php the_content(); ?>
        </div>

        <footer class="entry-footer">
            <div class="categories">
                <?php the_category(', '); ?>
            </div>

            <div class="tags">
                <?php the_tags('Tags: ', ', '); ?>
            </div>
        </footer>

    </article>

    <?php comments_template(); ?>

<?php endwhile; else : ?>

    <p>No content found.</p>

<?php endif; ?>

</main>

<?php get_footer(); ?>
